/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;

import jp.mosp.workflow.dto.AmUnitDto;

public class ApprovalUnitCardVo extends ApprovalMenuVo {

	private static final long serialVersionUID = 7639736442031032151L;

	// URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/workflow/approvalUnitCard.jsp";
	private static final String EXTRA_JS   = "/pub/workflow/js/approvalUnitCard.js";
	private static final String EXTRA_CSS  = "/pub/workflow/css/approvalUnitCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_APPROVAL_UNIT;

	// 萔
	public static final int MODE_INSERT 		= 0;
	public static final int MODE_UPDATE 		= 1;
	public static final int MODE_IMPOSSIBLE	= 2;

	// p[^
	public static final String PRM_TXT_UNIT_CODE		= "txtUnitCode";
	public static final String PRM_PLT_MAIN			= "pltMain";
	public static final String PRM_PLT_AGENT			= "pltAgent";
	public static final String PRM_PLT_START_YEAR    	= "pltStartYear";
	public static final String PRM_PLT_START_MONTH	 	= "pltStartMonth";
	/*						
	 *  	2008/11/04	m.yoshida	C
	 */
	public static final String PRM_PLT_START_DAY  	= "pltStartDay";
	public static final String PRM_PLT_DELETE			= "pltDelete";

	// tB[h
	private String txtUnitCode;
	private String pltMain;
	private String pltAgent;
	private String pltStartYear;
	private String pltStartMonth;
	/*						
	 *  	2008/11/04	m.yoshida	C
	 */
	private String pltStartDay;
	private String pltDelete;

	// v_EXg
	public String[][] aryPltManager;
	public String[][] aryPltYear;
	public String[][] aryPltMonth;
	public String[][] aryPltDay;

	// tB[hyѐ
	public static final String NAM_UNIT_CODE	= CommonConst.NAM_APPROVAL_UNIT + CommonConst.NAM_COMMON_CODE;
	public static final String NAM_MAIN		= CommonConst.NAM_APPROVED + CommonConst.NAM_PERSON;
	public static final String NAM_AGENT		= CommonConst.NAM_AGENT;
	public static final String NAM_START_DATE	= CommonConst.NAM_START_DATE;
	public static final String NAM_DELETE		= CommonConst.NAM_DELETE_FLAG;

	public static final int    LEN_CODE = 10;

	public static final String REG_DELETE  = CommonConst.REG_DELETE;

	/**
	 * RXgN^
	 */
	public ApprovalUnitCardVo() {
		super();
		mode = MODE_INSERT;
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
	}

	/**
	 * lݒ
	 */	
	public void setDefaultValues(){
		setTxtUnitCode("");
		setPltMain("");
		setPltAgent("");
		setPltStartYear("");
		setPltStartMonth("");
		/*						
		 *  	2008/11/04	m.yoshida	C
		 */
		setPltStartDay("");
		setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		txtUnitCode		= request.getParameter(PRM_TXT_UNIT_CODE);
		pltMain			= request.getParameter(PRM_PLT_MAIN);
		pltAgent		= request.getParameter(PRM_PLT_AGENT);
		pltStartYear	= request.getParameter(PRM_PLT_START_YEAR);
		pltStartMonth	= request.getParameter(PRM_PLT_START_MONTH);
		/*						
		 *  	2008/11/04	m.yoshida	C
		 */
		pltStartDay		= request.getParameter(PRM_PLT_START_DAY);
		pltDelete		= request.getParameter(PRM_PLT_DELETE);
	}

	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(AmUnitDto dto) {
		txtUnitCode		= dto.getUnitCode();
		pltMain			= dto.getMain();
		pltAgent 		= dto.getAgent();
		pltStartYear	= util.removeZero(util.divideByHyphen(dto.getStartDate(), 2)[0]);
		pltStartMonth	= util.removeZero(util.divideByHyphen(dto.getStartDate(), 2)[1]);
		/*						
		 *  	2008/11/04	m.yoshida	C
		 */
		pltStartDay		= util.removeZero(util.divideByHyphen(dto.getStartDate(), 2)[2]);
		pltDelete 		= String.valueOf(dto.getDeleteFlag());
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(AmUnitDto dto) {
		dto.setUnitCode(txtUnitCode);
		dto.setMain(pltMain);
		dto.setAgent(pltAgent);
		/*						
		 *  	2008/11/04	m.yoshida	C
		 */
		dto.setStartDate(util.convStringDateFormattedByHyphen(pltStartYear, pltStartMonth, pltStartDay));
		dto.setDeleteFlag(Integer.parseInt(pltDelete));
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtUnitCode	, NAM_UNIT_CODE	, PRM_TXT_UNIT_CODE);
		// 񒷊mF
		checkLength(txtUnitCode	, LEN_CODE	, NAM_UNIT_CODE	, PRM_TXT_UNIT_CODE);
		// dmF
		checkCompare(pltMain, pltAgent, 1, NAM_AGENT, PRM_PLT_MAIN, PRM_PLT_AGENT);
		// tmF
		/*						
		 *  	2008/11/04	m.yoshida	C
		 */
		checkDate(getIntParam(pltStartYear), getIntParam(pltStartMonth), getIntParam(pltStartDay), NAM_START_DATE, PRM_PLT_START_YEAR);		
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String getTxtUnitCode() 		{ return txtUnitCode	; }
	public String getPltMain() 			{ return pltMain		; }
	public String getPltAgent() 		{ return pltAgent		; }
	public String getPltStartYear() 	{ return pltStartYear	; }
	public String getPltStartMonth() 	{ return pltStartMonth	; }
	/*						
	 *  	2008/11/04	m.yoshida	C
	 */
	public String getPltStartDay() 		{ return pltStartDay	; }
	public String getPltDelete() 		{ return pltDelete		; }

	public String getEscTxtUnitCode() 		{ return escapeHTML(txtUnitCode)	; }
	/*						
	 *  	2008/11/04	m.yoshida	C
	 */
	public String getEscPltStartDay() 		{ return escapeHTML(pltStartDay)	; }

	public void setTxtUnitCode		(String txtUnitCode		) 	{ this.txtUnitCode 		= txtUnitCode	; }
	public void setPltMain			(String pltMain			) 	{ this.pltMain 			= pltMain		; }
	public void setPltAgent		(String pltAgent		) 	{ this.pltAgent 		= pltAgent		; }
	public void setPltStartYear	(String pltStartYear	) 	{ this.pltStartYear		= pltStartYear	; }
	public void setPltStartMonth	(String pltStartMonth	) 	{ this.pltStartMonth 	= pltStartMonth	; }
	/*						
	 *  	2008/11/04	m.yoshida	C
	 */
	public void setPltStartDay		(String pltStartDay		) 	{ this.pltStartDay 		= pltStartDay	; }
	public void setPltDelete		(String pltDelete		) 	{ this.pltDelete 		= pltDelete		; }

}
